/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IEditNPC;
import noppes.npcs.client.gui.util.IGuiTextArea;
import org.lwjgl.input.Mouse;

public class GuiNpcTextArea
extends GuiNpcTextField
implements IGuiTextArea {
    private boolean clickVerticalBar = false;
    private int cursorCounter;
    private int cursorPosition = 0;
    private final ClientProxy.FontContainer font;
    private final int height;
    private int listHeight;
    private final int posX;
    private final int posY;
    private float scrolledY = 0.0f;
    private int startClick = -1;
    private final int width;
    private final boolean wrapLine = true;

    public GuiNpcTextArea(int id, GuiScreen guiscreen, int x, int y, int width, int height, String text) {
        super(id, guiscreen, x, y, width, height, text);
        this.posX = x;
        this.posY = y;
        this.width = width;
        this.height = height;
        this.listHeight = height;
        this.font = ClientProxy.Font.copy();
        this.font.useCustomFont = true;
        this.func_146203_f(Integer.MAX_VALUE);
        this.setFullText(text.replace("\r\n", "\n"));
    }

    private void addScrollY(int scrolled) {
        float max;
        this.scrolledY -= 1.0f * (float)scrolled / (float)this.height;
        if (this.scrolledY < 0.0f) {
            this.scrolledY = 0.0f;
        }
        if (this.scrolledY > (max = 1.0f - 1.0f * (float)(this.height + 2) / (float)this.listHeight)) {
            this.scrolledY = max;
        }
    }

    private void drawCursorVertical(int startX, int startY, int endX, int endY) {
        int i1;
        if (startX < endX) {
            i1 = startX;
            startX = endX;
            endX = i1;
        }
        if (startY < endY) {
            i1 = startY;
            startY = endY;
            endY = i1;
        }
        if (endX > this.posX + this.width) {
            endX = this.posX + this.width;
        }
        if (startX > this.posX + this.width) {
            startX = this.posX + this.width;
        }
        BufferBuilder tessellator = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179115_u();
        GlStateManager.func_179116_f((int)5387);
        tessellator.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        tessellator.func_181662_b((double)startX, (double)endY, 0.0).func_181675_d();
        tessellator.func_181662_b((double)endX, (double)endY, 0.0).func_181675_d();
        tessellator.func_181662_b((double)endX, (double)startY, 0.0).func_181675_d();
        tessellator.func_181662_b((double)startX, (double)startY, 0.0).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179134_v();
        GlStateManager.func_179098_w();
    }

    public void drawString(String text, int x, int y, int color) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.font.drawString(text, x, y, color);
    }

    @Override
    public void render(IEditNPC gui, int mouseX, int mouseY, float partialTicks) {
        int dWheel;
        GuiNpcTextArea.func_73734_a((int)(this.posX - 1), (int)(this.posY - 1), (int)(this.posX + this.width + 1), (int)(this.posY + this.height + 1), (int)new Color(160, 160, 160, 255).getRGB());
        GuiNpcTextArea.func_73734_a((int)this.posX, (int)this.posY, (int)(this.posX + this.width), (int)(this.posY + this.height), (int)new Color(0, 0, 0, 255).getRGB());
        int color = new Color(224, 224, 224, 255).getRGB();
        boolean flag = this.func_146206_l() && this.cursorCounter / 6 % 2 == 0;
        int startLine = this.getStartLineY();
        int maxLine = this.height / this.font.height(this.getFullText()) + startLine;
        List<String> lines = this.getLines();
        int charCount = 0;
        int lineCount = 0;
        int maxSize = this.width - (this.isScrolling() ? 14 : 4);
        for (String wholeLine : lines) {
            String line = "";
            for (char c : wholeLine.toCharArray()) {
                if (this.font.width(line + c) > maxSize) {
                    if (lineCount >= startLine && lineCount < maxLine) {
                        this.drawString(line, this.posX + 4, this.posY + 4 + (lineCount - startLine) * this.font.height(line), color);
                    }
                    line = "";
                    ++lineCount;
                }
                if (flag && charCount == this.cursorPosition && lineCount >= startLine && lineCount < maxLine && this.canEdit) {
                    int xx = this.posX + this.font.width(line) + 4;
                    int yy = this.posY + (lineCount - startLine) * this.font.height(line) + 4;
                    if (this.getFullText().length() == this.cursorPosition) {
                        this.font.drawString("_", xx, yy, color);
                    } else {
                        this.drawCursorVertical(xx, yy, xx + 1, yy + this.font.height(line));
                    }
                }
                ++charCount;
                line = line + c;
            }
            if (lineCount >= startLine && lineCount < maxLine) {
                this.drawString(line, this.posX + 4, this.posY + 4 + (lineCount - startLine) * this.font.height(line), color);
                if (flag && charCount == this.cursorPosition && this.canEdit) {
                    int xx2 = this.posX + this.font.width(line) + 4;
                    int yy2 = this.posY + (lineCount - startLine) * this.font.height(line) + 4;
                    if (this.getFullText().length() == this.cursorPosition) {
                        this.font.drawString("_", xx2, yy2, color);
                    } else {
                        this.drawCursorVertical(xx2, yy2, xx2 + 1, yy2 + this.font.height(line));
                    }
                }
            }
            ++lineCount;
            ++charCount;
        }
        if (this.func_146206_l() && (dWheel = Mouse.getDWheel()) != 0) {
            this.addScrollY(dWheel < 0 ? -10 : 10);
        }
        if (Mouse.isButtonDown((int)0)) {
            if (this.clickVerticalBar) {
                if (this.startClick >= 0) {
                    this.addScrollY(this.startClick - (mouseY - this.posY));
                }
                this.startClick = mouseY - this.posY;
            }
        } else {
            this.clickVerticalBar = false;
        }
        this.listHeight = lineCount * this.font.height(this.getFullText());
        this.drawVerticalScrollBar();
    }

    private void drawVerticalScrollBar() {
        if (this.listHeight <= this.height - 4) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiCustomScroll.resource);
        int x = this.posX + this.width - 6;
        int y = (int)((float)this.posY + this.scrolledY * (float)this.height + 2.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int sbSize = this.getVerticalBarSize();
        this.func_73729_b(x, y, this.width, 9, 5, 1);
        for (int k = 0; k < sbSize; ++k) {
            this.func_73729_b(x, y + k, this.width, 10, 5, 1);
        }
        this.func_73729_b(x, y, this.width, 11, 5, 1);
    }

    private List<String> getLines() {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        for (char c : this.getFullText().toCharArray()) {
            if (c == '\r' || c == '\n') {
                list.add(line.toString());
                line = new StringBuilder();
                continue;
            }
            line.append(c);
        }
        list.add(line.toString());
        return list;
    }

    private int getStartLineY() {
        if (!this.isScrolling()) {
            this.scrolledY = 0.0f;
        }
        return MathHelper.func_76123_f((float)(this.scrolledY * (float)this.listHeight / (float)this.font.height(this.getFullText())));
    }

    private int getVerticalBarSize() {
        return (int)(1.0f * (float)this.height / (float)this.listHeight * (float)(this.height - 4));
    }

    private boolean hoverVerticalScrollBar(int x, int y) {
        return this.listHeight > this.height - 4 && this.posY < y && this.posY + this.height > y && x < this.posX + this.width && x > this.posX + (this.width - 8);
    }

    private boolean isScrolling() {
        return this.listHeight > this.height - 4;
    }

    @Override
    public boolean func_146192_a(int i, int j, int k) {
        super.func_146192_a(i, j, k);
        if (this.hoverVerticalScrollBar(i, j)) {
            this.clickVerticalBar = true;
            this.startClick = -1;
            return false;
        }
        if (k != 0 || !this.canEdit) {
            return false;
        }
        int x = i - this.posX;
        int y = (j - this.posY - 4) / this.font.height(this.getFullText()) + this.getStartLineY();
        this.cursorPosition = 0;
        List<String> lines = this.getLines();
        int charCount = 0;
        int lineCount = 0;
        int maxSize = this.width - (this.isScrolling() ? 14 : 4);
        for (String wholeLine : lines) {
            StringBuilder line = new StringBuilder();
            for (char c : wholeLine.toCharArray()) {
                this.cursorPosition = charCount;
                if (this.font.width(line.toString() + c) > maxSize) {
                    line = new StringBuilder();
                    if (y < ++lineCount) break;
                }
                if (lineCount == y && x <= this.font.width(line.toString() + c)) {
                    return true;
                }
                ++charCount;
                line.append(c);
            }
            this.cursorPosition = charCount++;
            if (y >= ++lineCount) continue;
            break;
        }
        if (y >= lineCount) {
            this.cursorPosition = this.getFullText().length();
        }
        return true;
    }

    @Override
    public boolean func_146201_a(char c, int i) {
        if (!this.func_146206_l() || !this.canEdit) {
            return false;
        }
        String originalText = this.getFullText();
        this.setFullText(originalText);
        if (c == '\r' || c == '\n') {
            this.setFullText(originalText.substring(0, this.cursorPosition) + c + originalText.substring(this.cursorPosition));
        }
        this.func_146196_d();
        this.func_146182_d(this.cursorPosition);
        boolean bo = super.func_146201_a(c, i);
        String newText = this.getFullText();
        if (i != 211) {
            this.cursorPosition += newText.length() - originalText.length();
        }
        if (i == 203 && this.cursorPosition > 0) {
            --this.cursorPosition;
        }
        if (i == 205 && this.cursorPosition < newText.length()) {
            ++this.cursorPosition;
        }
        return bo;
    }

    public void func_146178_a() {
        ++this.cursorCounter;
    }
}

